local PANEL = {};

// link to class
function PANEL:LinkToClass( cls )
	self.LinkedClass = cls;
	
end


// window init.
function PANEL:Init( )
	//
	self.LinkedClass = nil;
	
	// material
	self.Material = nil;

end

// set material
function PANEL:SetMaterial( mat )
	// get texture id.
	self.Material = surface.GetTextureID( mat );
	
end


// clicked
function PANEL:DoClick( )
	// call evbent
	if( self.LinkedClass ) then
		self.LinkedClass:CallEvent( "OnClick" );
		
	end	

end

// paint.
function PANEL:Paint( )
	// no icon!
	if( !self.Material ) then return; end
	
	// draw icon
	surface.SetDrawColor( 255, 255, 255, 255 );
	surface.SetTexture( self.Material );
	surface.DrawTexturedRect(
		0, 0,
		16, 16
	);
	
	//
	return true;
	
end

// register.
vgui.Register( "ctl_icon_button", PANEL, "Button" );



// create app framework control.
CtlIconButton_class 	= Control_class:create( nil, false, "ctl_icon_button" );


// set icon
function CtlIconButton_class:SetMaterial( icon )
	self:GetHandle():SetMaterial( icon );

end
